% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_predict.R
\name{.delta_method}
\alias{.delta_method}
\title{Delta method point estimation}
\usage{
.delta_method(fit, x_new, se_interval = "confidence")
}
\arguments{
\item{fit}{A fit object which is located inside a modeler object}

\item{x_new}{A vector of x values to evaluate the function.}

\item{se_interval}{A character string. "confidence" or "prediction".}
}
\value{
A data.frame of the evaluated values.
}
\description{
Delta method point estimation
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
# Point Prediction
predict(mod_1, x = 45, type = "point", id = 2)
}
\keyword{internal}
