% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchange_refresh_token.R
\name{exchange_refresh_token}
\alias{exchange_refresh_token}
\title{Exchange a refresh token for an ID token}
\usage{
exchange_refresh_token(refresh_token)
}
\arguments{
\item{refresh_token}{String. A Firebase Auth refresh token.}
}
\value{
A named list with the following items:
\itemize{
\item \code{expires_in}: The number of seconds in which the ID token expires.
\item \code{token_type}: The type of the refresh token, always "Bearer".
\item \code{refresh_token}: The Firebase Auth refresh token provided, or a new
refresh token.
\item \code{id_token}: A Firebase Auth ID token.
\item \code{user_id}: The uid corresponding to the provided ID token.
\item \code{project_id}: Your Firebase project ID.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Refreshes a Firebase ID token
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-refresh-token}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  # first sign in user and get the 'refresh_token':
  user <- sign_in(email = "user@gmail.com", password = "password")
  refresh_token <- user$refreshToken

  # exchange the refresh token:
  response <- exchange_refresh_token(refresh_token = refresh_token)
  response
}
}
