% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_metrics.R
\name{ff_metrics}
\alias{ff_metrics}
\alias{ff_metrics.lm}
\alias{ff_metrics.lmlist}
\alias{ff_metrics.glm}
\alias{ff_metrics.glmlist}
\alias{ff_metrics.lmerMod}
\alias{ff_metrics.glmerMod}
\alias{ff_metrics.coxph}
\alias{ff_metrics.coxphlist}
\title{Generate common metrics for regression model results}
\usage{
ff_metrics(.data)

\method{ff_metrics}{lm}(.data)

\method{ff_metrics}{lmlist}(.data)

\method{ff_metrics}{glm}(.data)

\method{ff_metrics}{glmlist}(.data)

\method{ff_metrics}{lmerMod}(.data)

\method{ff_metrics}{glmerMod}(.data)

\method{ff_metrics}{coxph}(.data)

\method{ff_metrics}{coxphlist}(.data)
}
\arguments{
\item{.data}{Model output.}
}
\value{
Model metrics vector for output.
}
\description{
Generate common metrics for regression model results
}
\examples{
library(finalfit)

# glm
fit = glm(mort_5yr ~  age.factor + sex.factor + obstruct.factor + perfor.factor,
  data=colon_s, family="binomial")
fit \%>\%
  ff_metrics()

# glmlist
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
colon_s \%>\%
  glmmulti(dependent, explanatory) \%>\%
  ff_metrics()

# glmerMod
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
random_effect = "hospital"
dependent = "mort_5yr"
colon_s \%>\%
  glmmixed(dependent, explanatory, random_effect) \%>\%
  ff_metrics()

# lm
fit = lm(nodes ~  age.factor + sex.factor + obstruct.factor + perfor.factor,
  data=colon_s)
fit \%>\%
  ff_metrics()

# lmerMod
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
random_effect = "hospital"
dependent = "nodes"

colon_s \%>\%
  lmmixed(dependent, explanatory, random_effect) \%>\%
  ff_metrics()

# coxphlist
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "Surv(time, status)"


colon_s \%>\%
  coxphmulti(dependent, explanatory) \%>\%
  ff_metrics()

# coxph
fit = survival::coxph(survival::Surv(time, status) ~ age.factor + sex.factor +
  obstruct.factor + perfor.factor,
  data = colon_s)

fit \%>\%
  ff_metrics()
}
