% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_plot.R
\name{surv_plot}
\alias{surv_plot}
\title{Plot survival curves with number-at-risk table}
\usage{
surv_plot(.data, dependent, explanatory, ...)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1:  Survival object of the form \code{Surv(time, status)}.}

\item{explanatory}{Character vector of max length 2: quoted name(s) of explanatory variables.}

\item{...}{Arguments passed to \code{\link[survminer]{ggsurvplot}}.}
}
\value{
Returns a table and plot produced in \code{ggplot2}.
}
\description{
Produce a survival curve plot and number-at-risk table using \code{survminer::ggsurvplot}
  and \code{finalfit} conventions.
}
\examples{
library(finalfit)
library(dplyr)

# Survival plot
data(colon_s)
explanatory = c("perfor.factor")
dependent = "Surv(time, status)"
colon_s \%>\%
  surv_plot(dependent, explanatory, xlab="Time (days)", pval=TRUE, legend="none")

}
\seealso{
Other finalfit plot functions: \code{\link{hr_plot}},
  \code{\link{or_plot}}
}
\concept{finalfit plot functions}
