% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fibos_execute.R
\name{execute}
\alias{execute}
\title{Surface Calculation}
\usage{
execute(pdb, method)
}
\arguments{
\item{pdb}{4-digit PDB id (will fetch it from the RCSB repository) or the path to a PDB local file.}

\item{method}{Method to be used: 'OS' (classic) or 'FIBOS' (default). The classic 'OS' covers the surface radially with one of the axes as a reference when allocating the dots. In 'FIBOS', Fibonacci spirals were used to allocate the dots, which is known to produce lower axial anisotropy as well as more evenly spaced points on a sphere.}
}
\value{
A data frame containing the protein surface data read from the generated SRF file.
}
\description{
The function executes the implemented methods.
Using this function, it is possible to calculate occluded areas
through the traditional methodology, 'Occluded Surface', or by
applying the 'Fibonacci OS' methodology. At the end of the method
execution, the 'prot.srf' file is generated, and returned for
the function. The data in this file refers to all contacts
between atoms of molecules present in a protein's PDB.
}
\author{
Carlos Henrique da Silveira (carlos.silveira@unifei.edu.br)

Herson Hebert Mendes Soares (hersonhebert@hotmail.com)

Joao Paulo Roquim Romanelli (joaoromanelli@unifei.edu.br)

Patrick Fleming (Pat.Fleming@jhu.edu)
}
\keyword{internal}
