% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{select_metadata}
\alias{select_metadata}
\title{Select Metadata}
\usage{
select_metadata(variable_name = NULL, fields = NULL,
  returnDataFrame = TRUE)
}
\arguments{
\item{variable_name}{name of variable}

\item{fields}{specific field or list of fields of variable to be accessed. See
details for valid field names}

\item{returnDataFrame}{optional parameter set to TRUE by default, output is
named list if set to FALSE}
}
\value{
returns string with value of a given field if field is specified,
returns all metadata for variable as data frame if field is unspecified
}
\description{
select_metadata allows users to retrieve the value of
a specific field or fields of a given variable, or
the entire variable metadata if no field is specified
}
\details{
List of valid field names:
\itemize{
    \item{data_source}
    \item{data_type}
    \item{fp_PCG}
    \item{fp_father}
    \item{fp_fchild}
    \item{fp_mother}
    \item{fp_other}
    \item{fp_partner}
    \item{group_id}
    \item{group_subid}
    \item{id}
    \item{label}
    \item{leaf}
    \item{measures}
    \item{name}
    \item{old_name}
    \item{probe}
    \item{qText}
    \item{respondent}
    \item{scope}
    \item{section}
    \item{warning}
    \item{wave}
}
}
\examples{
select1 <- select_metadata(variable_name = "ce3agefc")

select2 <- select_metadata(variable_name = "ce3agefc", fields = "data_type")

select3 <- select_metadata(variable_name = "ce3agefc", fields = c("data_type", "data_source"))
}
