% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_admin.R
\name{bkg_admin_hierarchy}
\alias{bkg_admin_hierarchy}
\title{Administrative hierarchy}
\usage{
bkg_admin_hierarchy(
  key_date = c("0101", "1231"),
  year = "latest",
  timeout = 120,
  update_cache = FALSE
)
}
\arguments{
\item{key_date}{For \code{resolution \%in\% c("250", "5000")}, specifies the key
date from which to download administrative data. Can be either \code{"0101"}
(January 1) or \code{"1231"} (December 31). The latter is able to
georeference statistical data while the first integrates changes made
in the new year. If \code{"1231"}, population data is attached, otherwise
not. Note that population data is not available at all scales (usually
250 and 1000). Defaults to "0101".}

\item{year}{Version year of the dataset. You can use \code{latest} to
retrieve the latest dataset version available on the BKG's geodata center.
Older versions can be browsed using the
\href{https://daten.gdz.bkg.bund.de/produkte/}{archive}.}

\item{timeout}{Timeout value for the data download passed to
\code{\link[httr2]{req_timeout}}. Adjust this if your internet connection is
slow or you are downloading larger datasets.}

\item{update_cache}{By default, downloaded files are cached in the
\code{tempdir()} directory of R. When downloading the same data again,
the data is not downloaded but instead taken from the cache. Sometimes
this can be not the desired behavior. If you want to overwrite the cache,
pass \code{TRUE}. Defaults to \code{FALSE}, i.e. always adopt the cache
if possible.}
}
\value{
An sf tibble with multipolygon geometries similar to the output
of \code{\link{bkg_admin}(level = "gem")}. The tibble additionally contains
columns \code{NUTS*_CODE} and \code{NUTS*_NAME} giving the identifiers and
names of the administrative areas the municipalities belong to.
}
\description{
Retrieve polygon geometries of municipalities in Germany with details on
their relationships to administrative areas of higher levels in the
territorial hierarchy. The output of this functions contains the identifiers
and names of the NUTS1 to NUTS3 areas that each municipality belongs to.
}
\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bkg_admin_hierarchy()
\dontshow{\}) # examplesIf}
}
