% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework-full.R
\name{framework_full}
\alias{framework_full}
\title{Orchestrate the Full FFA Framework}
\usage{
framework_full(
  data,
  years,
  ns_splits = NULL,
  ns_structures = NULL,
  generate_report = TRUE,
  report_path = NULL,
  report_formats = "html",
  ...
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{ns_splits}{An integer vector of years used to split the data into homogeneous
subperiods. For S-FFA, set to \code{NULL} (default). For NS-FFA, specify an \emph{integer} vector
of years with physical justification for change points, or \code{NULL} if no such years exist.
In R, integers have the suffix \code{L}, so \code{1950L} is a valid input to \code{ns_splits}, but \code{1950}
is not (since R may interpret it as a floating point number).}

\item{ns_structures}{For S-FFA, set to \code{NULL} (default) to use a stationary model
for all homogeneous subperiods. For NS-FFA, provide a list of \code{length(ns_splits) + 1}
sublists specifying the nonstationary model structure for each homogeneous subperiod.
Each sublist must contain logical elements \code{location} and \code{scale}, indicating
monotonic trends in the mean and variability, respectively.}

\item{generate_report}{If \code{TRUE} (default), generate a report.}

\item{report_path}{A character scalar, the file path for the generated report.
If \code{NULL} (default), the report will be saved to a new temporary directory.}

\item{report_formats}{A character vector specifying the output format for the
report. Supported values are \code{"md"}, \code{"pdf"}, \code{"html"}, and \code{"json"}.}

\item{...}{Additional arguments to be passed to the statistical tests and frequency
analysis functions. See the details of \code{\link[=framework_eda]{framework_eda()}} and \code{\link[=framework_ffa]{framework_ffa()}} for a
complete list.}
}
\value{
\code{eda_recommendations}: See \code{\link[=framework_eda]{framework_eda()}}.

\code{modelling_assumptions}: See \code{\link[=framework_ffa]{framework_ffa()}}.

\code{submodule_results}: A list of lists of results. Each list contains:
\itemize{
\item \code{name}: Either "Change Point Detection", "Trend Detection", "Distribution
Selection", "Parameter Estimation", "Uncertainty Quantification", or "Model
Assessment".
\item \code{start}: The first year of the homogeneous subperiod.
\item \code{end}: The last year of the homogeneous subperiod.
\item Additional items specific to the the submodule.
}
}
\description{
Runs the entire flood frequency analysis framework using the results of exploratory
data analysis (EDA) to guide approach selection (stationary or nonstationary) and
perform flood frequency analysis. Returns a comprehensive and reproducible summary
of the results.
}
\seealso{
\code{\link[=framework_eda]{framework_eda()}}, \code{\link[=framework_ffa]{framework_ffa()}}
}
