% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_lag}
\alias{gg_lag}
\title{Lag plots}
\usage{
gg_lag(
  data,
  y = NULL,
  period = NULL,
  lags = 1:9,
  geom = c("path", "point"),
  arrow = FALSE,
  ...
)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{period}{The seasonal period to display. If NULL (default),
the largest frequency in the data is used. If numeric, it represents
the frequency times the interval between observations. If a string
(e.g., "1y" for 1 year, "3m" for 3 months, "1d" for 1 day,
"1h" for 1 hour, "1min" for 1 minute, "1s" for 1 second),
it's converted to a Period class object from the lubridate package.
Note that the data must have at least one observation per seasonal period,
and the period cannot be smaller than the observation interval.}

\item{lags}{A vector of lags to display as facets.}

\item{geom}{The geometry used to display the data.}

\item{arrow}{Arrow specification to show the direction in the lag path. If
TRUE, an appropriate default arrow will be used. Alternatively, a user
controllable arrow created with \code{\link[grid:arrow]{grid::arrow()}} can be used.}

\item{...}{Additional arguments passed to the geom.}
}
\value{
A ggplot object showing a lag plot of a time series.
}
\description{
A lag plot shows the time series against lags of itself. It is often coloured
the seasonal period to identify how each season correlates with others.
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_lag(Turnover)

}
