% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{feat_acf}
\alias{feat_acf}
\title{Autocorrelation-based features}
\usage{
feat_acf(x, .period = 1, lag_max = NULL, ...)
}
\arguments{
\item{x}{a univariate time series}

\item{.period}{The seasonal period (optional)}

\item{lag_max}{maximum lag at which to calculate the acf. The default is
\code{max(.period, 10L)} for \code{feat_acf}, and \code{max(.period, 5L)} for \code{feat_pacf}}

\item{...}{Further arguments passed to \code{\link[stats:acf]{stats::acf()}} or \code{\link[stats:pacf]{stats::pacf()}}}
}
\value{
A vector of 6 values: first autocorrelation coefficient and sum of squared of
first ten autocorrelation coefficients of original series, first-differenced series,
and twice-differenced series.
For seasonal data, the autocorrelation coefficient at the first seasonal lag is
also returned.
}
\description{
Computes various measures based on autocorrelation coefficients of the
original series, first-differenced series and second-differenced series
}
\author{
Thiyanga Talagala
}
