% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_slice.R
\name{f_slice}
\alias{f_slice}
\alias{f_slice_head}
\alias{f_slice_tail}
\alias{f_slice_min}
\alias{f_slice_max}
\alias{f_slice_sample}
\title{Faster \code{dplyr::slice()}}
\usage{
f_slice(data, i = 0L, ..., .by = NULL, keep_order = FALSE)

f_slice_head(data, n, prop, .by = NULL, keep_order = FALSE)

f_slice_tail(data, n, prop, .by = NULL, keep_order = FALSE)

f_slice_min(
  data,
  order_by,
  n,
  prop,
  .by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  keep_order = FALSE
)

f_slice_max(
  data,
  order_by,
  n,
  prop,
  .by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  keep_order = FALSE
)

f_slice_sample(
  data,
  n,
  replace = FALSE,
  prop,
  .by = NULL,
  keep_order = FALSE,
  weights = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{i}{An \link{integer} vector of slice locations. \cr
Please see the details below on how \code{i} works as it
only accepts simple integer vectors.}

\item{...}{A temporary argument to give the user an error if dots are used.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{keep_order}{Should the sliced data frame be returned in its original order?
The default is \code{FALSE}.}

\item{n}{Number of rows.}

\item{prop}{Proportion of rows.}

\item{order_by}{Variables to order by.}

\item{with_ties}{Should ties be kept together? The default is \code{TRUE}.}

\item{na_rm}{Should missing values in \code{f_slice_max()} and \code{f_slice_min()} be removed?
The default is \code{FALSE}.}

\item{replace}{Should \code{f_slice_sample()} sample with or without replacement?
Default is \code{FALSE}, without replacement.}

\item{weights}{Probability weights used in \code{f_slice_sample()}.}

\item{seed}{Seed number defining RNG state.
If supplied, this is only applied \bold{locally} within the function
and the seed state isn't retained after sampling.
To clarify, whatever seed state was in place before the function call,
is restored to ensure seed continuity.
If left \code{NULL} (the default), then the seed is never modified.}
}
\value{
A \code{data.frame} filtered on the specified row indices.
}
\description{
When there are lots of groups, the \code{f_slice()} functions are much faster.
}
\details{
\subsection{Important note about the \code{i} argument in \code{f_slice}}{

\code{i} is first evaluated on an un-grouped basis and then searches for
those locations in each group. Thus if you supply an expression
of slice locations that vary by-group, this will not be respected nor checked.
For example, \cr
do \code{f_slice(data, 10:20, .by = group)} \cr
not \code{f_slice(data, sample(1:10), .by = group)}. \cr

The former results in slice locations that do not vary by group but the latter
will result in different within-group slice locations which \code{f_slice} cannot
correctly compute.

To do the the latter type of by-group slicing, use \code{f_filter}, e.g.
\code{f_filter(data, row_number() \%in\% slices, .by = groups)}
}

\subsection{\code{f_slice_sample}}{

The arguments of \code{f_slice_sample()} align more closely with \code{base::sample()} and thus
by default re-samples each entire group without replacement.
}
}
