% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_engine_names}
\alias{get_engine_names}
\title{Get Engine Names from Model Workflows}
\usage{
get_engine_names(models)
}
\arguments{
\item{models}{A list where each element is a list of model workflows. Each workflow is expected to contain a fitted model that can be processed with \code{tune::extract_fit_parsnip}.}
}
\value{
A list of character vectors. Each vector contains the unique engine names extracted from the corresponding element of \code{models}.
}
\description{
Extracts and returns a list of unique engine names from a list of model workflows.
}
\details{
The function applies \code{tune::extract_fit_parsnip} to each model workflow to extract the fitted model object. It then retrieves the engine name from the model specification (\code{spec$engine}). If the extraction fails, \code{NA_character_} is returned for that workflow. Finally, the function removes any duplicate engine names using \code{unique}.
}
