% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_best_model_names}
\alias{get_best_model_names}
\title{Get Best Model Names}
\usage{
get_best_model_names(models)
}
\arguments{
\item{models}{A named list where each element corresponds to an algorithm and contains a list of model workflows.
Each workflow should be compatible with \code{tune::extract_fit_parsnip}.}
}
\value{
A named character vector. The names of the vector correspond to the algorithm names, and the values represent the chosen best engine name for that algorithm.
}
\description{
Extracts and returns the best engine names from a named list of model workflows.
}
\details{
For each algorithm, the function extracts the engine names from the model workflows using \code{tune::extract_fit_parsnip}.
  It then chooses \code{"randomForest"} if it is available; otherwise, it selects the first non-\code{NA} engine.
  If no engine names can be extracted for an algorithm, \code{NA_character_} is returned.
}
