% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-fEGarch_risk.R
\name{plot,fEGarch_risk,ANY-method}
\alias{plot,fEGarch_risk,ANY-method}
\alias{plot,fEGarch_risk-method}
\title{Plotting of Risk Measure Results (Base R)}
\usage{
\S4method{plot}{fEGarch_risk,ANY}(x, y = NULL, which = NULL, ...)
}
\arguments{
\item{x}{an object returned by \code{measure_risk}.}

\item{y}{for compatibility but without use.}

\item{which}{one of the levels of VaR and ES saved in
\code{object}, usually either \code{0.975} or \code{0.99}
by default.}

\item{...}{without use.}
}
\value{
Returns nothing but produces a base R plot in the plot window.
}
\description{
Plot risk measure results returned by \code{measure_risk}
as a points-over-threshold plot in style of base R plots.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2003-12-31")

egarch_spec() \%>\%
 fEGarch(rt = rt, n_test = 250) \%>\%
 predict_roll() \%>\%
 measure_risk() \%>\%
 plot(which = 0.99)


}
