% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popular-methods.R
\name{fitted,fEGarch_fit-method}
\alias{fitted,fEGarch_fit-method}
\alias{fitted,fEGarch_forecast-method}
\title{Extract Fitted Conditional Means}
\usage{
\S4method{fitted}{fEGarch_fit}(object)

\S4method{fitted}{fEGarch_forecast}(object)
}
\arguments{
\item{object}{an object either of class \code{"fEGarch_fit"} or
\code{"fEGarch_forecast"}.}
}
\value{
The element within the input object with name \code{cmeans} is returned.
Depending on the element that can be a numeric vector, an object of
class "zoo" or a numeric matrix.
}
\description{
An alternative to \code{\link{cmeans,fEGarch_fit-method}} to extract
fitted conditional means from an estimation object
in this package.
}
\details{
Extract fitted conditional means from an estimation object
in this package.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
model <- fEGarch(egarch_spec(), rt, n_test = 250)
fitted(model)

}
