% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-functions.R
\name{fit_test_suite,fEGarch_fit-method}
\alias{fit_test_suite,fEGarch_fit-method}
\title{Post-Estimation Fit-Tests}
\usage{
\S4method{fit_test_suite}{fEGarch_fit}(
  object,
  args_lbt = list(),
  args_sbt = list(),
  args_goft = list(),
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"fEGarch_fit"} as returned
by the fitting functions of this package like for example
\code{\link{fEGarch}}.}

\item{args_lbt}{a list of changes to make to the default argument settings in
\code{ljung_box_test}.}

\item{args_sbt}{a list of changes to make to the default argument settings in
\code{sign_bias_test}.}

\item{args_goft}{a list of changes to make to the default argument settings in
\code{goodn_of_fit_test}.}

\item{silent}{a logical indicating whether or not to print
the test results in a well-formatted manner to the console.}

\item{...}{currently without purpose.}
}
\value{
Returns a list with the four test results invisibly.
}
\description{
Apply a collection of fit-tests, including
a weighted Ljung-Box test for the simple and the squared
standardized residuals, a sign-bias test, and an
adjusted Pearson goodness-of-fit test.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
spec <- fEGarch_spec()
model <- fEGarch(spec, rt)
fit_test_suite(model)

}
