% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-egarch-spec.R, R/class-fEGarch_forecast.R
\name{accessor_methods}
\alias{accessor_methods}
\alias{sigt,fEGarch_fit-method}
\alias{cmeans,fEGarch_fit-method}
\alias{etat,fEGarch_fit-method}
\alias{inf_criteria,fEGarch_fit-method}
\alias{llhood,fEGarch_fit-method}
\alias{pars,fEGarch_fit-method}
\alias{se,fEGarch_fit-method}
\alias{vcov_mat,fEGarch_fit-method}
\alias{sigt,fEGarch_forecast-method}
\alias{cmeans,fEGarch_forecast-method}
\title{Methods for Accessing Model Estimation and Forecasting Output Elements}
\usage{
\S4method{sigt}{fEGarch_fit}(x)

\S4method{cmeans}{fEGarch_fit}(x)

\S4method{etat}{fEGarch_fit}(x)

\S4method{inf_criteria}{fEGarch_fit}(x)

\S4method{llhood}{fEGarch_fit}(x)

\S4method{pars}{fEGarch_fit}(x)

\S4method{se}{fEGarch_fit}(x)

\S4method{vcov_mat}{fEGarch_fit}(x)

\S4method{sigt}{fEGarch_forecast}(x)

\S4method{cmeans}{fEGarch_forecast}(x)
}
\arguments{
\item{x}{an object returned by either \code{\link{fEGarch}},
\code{\link{garchm_estim}}, \code{predict} (for \code{sigt} and \code{cmeans})
or \code{predict_roll} (for \code{sigt} and \code{cmeans}).}
}
\value{
The element within the input object of the same name as the method
is returned. Depending on the element that can be a numeric vector,
an object of class \code{"zoo"} or a numeric matrix.
}
\description{
Accessors to access the elements of the same name in
output objects returned by either \code{\link{fEGarch}},
\code{\link{garchm_estim}}, \code{predict} or \code{predict_roll}.
}
\details{
Convenience methods to access the elements of the same name
that can otherwise be accessed via the operator \code{@} within
objects that inherit from class \code{"fEGarch_fit"}, which covers
objects returned by either \code{\link{fEGarch}},
\code{\link{garchm_estim}}, \code{predict} (for \code{sigt} and \code{cmeans})
or \code{predict_roll} (for \code{sigt} and \code{cmeans}).

As alternatives for \code{sigt}, \code{cmeans} and \code{etat}, see also
\code{\link{sigma,fEGarch_fit-method}}, \code{\link{fitted,fEGarch_fit-method}}
and \code{\link{residuals,fEGarch_fit-method}}.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, start = "2010-01-01", end = "2012-12-31")
est <- fEGarch(egarch_spec(), rt)

# Access estimated conditional standard deviations using
# the common operator "@" ...
sigt1 <- est@sigt

# ... or use the accessor method "sigt()"
sigt2 <- sigt(est)

zoo::plot.zoo(
 cbind("Approach 1" = sigt1, "Approach 2" = sigt2)
)

# Other methods
cmeans(est)
etat(est)
inf_criteria(est)
llhood(est)
pars(est)
se(est)
vcov_mat(est)

}
