% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data_brownian.R
\name{generate_brownian_motion}
\alias{generate_brownian_motion}
\title{Generate a Brownian Motion Process}
\usage{
generate_brownian_motion(N, v = 30, sd = 1)
}
\arguments{
\item{N}{Numeric. The number of observations for the generated data.}

\item{v}{Numeric (vector). Discretization points of the curves.This can be
the evaluated points or the number of evenly spaced points on [0,1].
By default it is evenly spaced on [0,1] with 30 points.}

\item{sd}{Numeric. Standard deviation of the Brownian Motion process.
The default is \code{1}.}
}
\value{
Functional time series (dfts) object.
}
\description{
Generate a functional time series according to an iid Brownian Motion process.
Each observation is discretized on the points indicated in \code{v}.
}
\examples{
bmotion <- generate_brownian_motion(N=100,
  v=c(0,0.25,0.4,0.7, 1, 1.5), sd = 1)
bmotion1 <- generate_brownian_motion(N=100,
  v=10, sd = 2)
}
