% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-bidsify.R
\name{bidsify}
\alias{bidsify}
\title{Save out pupil timeseries data in a BIDS-like structure}
\usage{
bidsify(
  eyeris,
  save_all = TRUE,
  epochs_list = NULL,
  merge_epochs = FALSE,
  bids_dir = NULL,
  participant_id = NULL,
  session_num = NULL,
  task_name = NULL,
  run_num = NULL,
  merge_runs = FALSE,
  save_raw = TRUE,
  html_report = FALSE,
  pdf_report = FALSE,
  report_seed = 0,
  report_epoch_grouping_var_col = "matched_event",
  verbose = TRUE
)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} dervived from \code{\link[=load]{load()}}.}

\item{save_all}{Logical flag indicating whether all epochs are to be saved
or only a subset of them. Defaults to TRUE.}

\item{epochs_list}{List of epochs to be saved. Defaults to NULL.}

\item{merge_epochs}{Logical flag indicating whether epochs should be saved
as one file or as separate files. Defaults to FLASE (no merge).}

\item{bids_dir}{Base bids_directory.}

\item{participant_id}{BIDS subject ID.}

\item{session_num}{BIDS session ID.}

\item{task_name}{BIDS task ID.}

\item{run_num}{BIDS run ID. For single files without blocks (i.e., runs),
\code{run_num} specifies which run this file represents. However, for files
with multiple recording blocks embedded within the \strong{same} \code{.asc} file,
this parameter is ignored and blocks are automatically numbered as runs
(block 1 = run-01, block 2 = run-02, etc.) in the order they appeared/were
recorded.}

\item{merge_runs}{Logical flag indicating whether multiple runs (either
from multiple recording blocks existing within the \strong{same} \code{.asc} file
(see above), or manually specified) should be combined into a single
output file. When TRUE, adds a 'run' column to identify the source run.
Defaults to FALSE (i.e., separate files per block/run -- the standard
BIDS-like-behavior).}

\item{save_raw}{Logical flag indicating whether to save_raw pupil data in
addition to epoched data. Defaults to TRUE.}

\item{html_report}{Logical flag indicating whether to save out the \code{eyeris}
preprocessing summary report as an HTML file. Defaults to FALSE.}

\item{pdf_report}{Logical flag indicating whether to save out the \code{eyeris}
preprocessing summary report as a PDF file. Note, a valid TeX distribution
must already be installed. Defaults to FALSE.}

\item{report_seed}{Random seed for the plots that will appear in the report.
Defaults to 0. See \code{\link[=plot]{plot()}} for a more detailed description.}

\item{report_epoch_grouping_var_col}{String name of grouping column to use
for epoch-by-epoch diagnostic plots in an interactive rendered HTML report.
Column name must exist (i.e., be a custom grouping variable name set within
the metadata template of your \code{epoch()} call). Defaults to \code{"matched_event"},
which all epoched dataframes have as a valid column name. To disable these
epoch-level diagnostic plots, set to \code{NULL}.}

\item{verbose}{A flag to indicate whether to print detailed logging messages.
Defaults to \code{TRUE}. Set to \code{False} to suppress messages about the current
processing step and run silently.}
}
\value{
Invisibly returns \code{NULL}. Called for its side effects.
}
\description{
This method provides a structured way to save out pupil data in a BIDS-like
structure. The method saves out epoched data as well as the raw pupil
timeseries, and formats the directory and filename structures based on the
metadata you provide.
}
\details{
In the future, we intend for this function to save out the data in an
official BIDS format for eyetracking data (see \href{https://github.com/bids-standard/bids-specification/pull/1128}{the proposal currently under review here}).
At this time, however, this function instead takes a more BIDS-inspired
approach to organizing the output files for preprocessed pupil data.
}
\examples{
# Bleed around blink periods just long enough to remove majority of
#  deflections due to eyelid movements
\donttest{
demo_data <- eyelink_asc_demo_dataset()

demo_data |>
  eyeris::glassbox(deblink = list(extend = 50)) |>
  eyeris::epoch(
    events = "PROBE_{type}_{trial}",
    limits = c(-1, 1), # grab 1 second prior to and 1 second post event
    label = "prePostProbe" # custom epoch label name
  ) |>
  eyeris::bidsify(
    bids_dir = tempdir(),
    participant_id = "001",
    session_num = "01",
    task_name = "assocret",
    run_num = "01",
    save_raw = TRUE, # save out raw timeseries
    html_report = TRUE, # generate interactive report document
    report_seed = 0 # make randomly selected plot epochs reproducible
  )
}

}
