% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-detrend.R
\name{detrend}
\alias{detrend}
\title{Detrend the pupil time series}
\usage{
detrend(eyeris)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} dervived from \code{\link[=load]{load()}}.}
}
\value{
An \code{eyeris} object with two new columns in \code{timeseries}:
\code{detrend_fitted_betas}, and \verb{pupil_raw_\{...\}_detrend}.
}
\description{
Linearly detrend_pupil data by fitting a linear model of \code{pupil_data ~ time},
and return the fitted betas and the residuals (\code{pupil_data - fitted_values}).
}
\examples{
system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = 50) |>
  eyeris::detransient() |>
  eyeris::interpolate() |>
  eyeris::lpfilt(plot_freqz = TRUE) |>
  eyeris::detrend() |>
  plot(seed = 0)

}
