% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_cv.R
\name{mc_cv}
\alias{mc_cv}
\title{Monte Carlo Critical Values}
\usage{
mc_cv(n, nrep = 2000, minw, opt_badf = c("fixed", "asymptotic",
  "simulated"), opt_bsadf = c("conventional", "conservative"))
}
\arguments{
\item{n}{A positive integer. The sample size.}

\item{nrep}{A positive integer. The number of Monte Carlo simulations.}

\item{minw}{A positive integer. The minimum window size, which defaults to
\eqn{(0.01 + 1.8/\sqrt(T))*T}{(0.01 + 1.8 / \sqrtT)*T}.}

\item{opt_badf}{Options for badf critical value calculation. "fixed" corresponds
to log(log(n*s))/100 rule, "asymptotic" to asymptotic critical values and
simulated to the monte carlo simulations.}

\item{opt_bsadf}{Options for bsadf critical value calculation. "conventional"
corresponds to the max of the quantile of the simulated distribution, while
"conservative" corresponds to the quantile of the max which is more conservative
in nature, thus the name.}
}
\value{
A list that contains the critical values for ADF, BADF, BSADF and GSADF
t-statistics.
}
\description{
\code{mc_cv} computes Monte Carlo critical values for the recursive unit
root tests.
}
\examples{
\donttest{
# Default minimum window
mc <- mc_cv(n = 100)

# Change the minimum window and the number of simulations
mc <- mc_cv(n = 100, nrep = 2500,  minw = 20)
}
}
\seealso{
\code{\link{wb_cv}} for Wild Bootstrapped critical values and
\code{\link{sb_cv}} for Sieve Bootstrapped critical values
}
