% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf.R
\name{radf}
\alias{radf}
\title{Recursive Augmented Dickey-Fuller Test}
\usage{
radf(data, minw, lag = 0)
}
\arguments{
\item{data}{A univariate or multivariate numeric ts object, data.frame or matrix.
The estimation process cannot handle NA values.}

\item{minw}{A positive integer. The minimum window size, which defaults to
\eqn{(0.01 + 1.8/\sqrt(T))*T}{(0.01 + 1.8 / \sqrtT)*T}.}

\item{lag}{A non-negative integer. The lag of the Augmented Dickey-Fuller regression.}
}
\value{
A list that contains the t-statistic (sequence) for:
  \item{adf}{Augmented Dickey-Fuller}
  \item{badf}{Backward Augmented Dickey-Fuller}
  \item{sadf}{Supremum Augmented Dickey-Fuller}
  \item{bsadf}{Backward Supremum Augmented Dickey-Fuller}
  \item{gsadf}{Generalized Supremum Augmented Dickey-Fuller}
}
\description{
\code{radf} returns the t-statistics from a recursive Augmented Dickey-Fuller
test.
}
\examples{
\donttest{
# Simulate bubble processes
dta <- cbind(sim_dgp1(n = 100), sim_dgp2(n = 100))

rfd <- radf(dta)

# For lag = 1 and minimum window = 20
rfd <- radf(dta, minw = 20, lag = 1)
}
}
\references{
Phillips, P. C. B., Wu, Y., & Yu, J. (2011). Explosive Behavior
in The 1990s Nasdaq: When Did Exuberance Escalate Asset Values? International
Economic Review, 52(1), 201-226.

Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
