% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasMod.R
\name{seasMod}
\alias{seasMod}
\title{Create Fourier representation of a periodic exDQLM component}
\usage{
seasMod(p, h, m0, C0)
}
\arguments{
\item{p}{The period.}

\item{h}{Vector of harmonics to be included.}

\item{m0}{Prior mean of the state vector.}

\item{C0}{Prior covariance of the state vector.}
}
\value{
A list of the following:
\itemize{
\item FF - Observational vector.
\item GG - Evolution matrix.
\item m0 - Prior mean of the state vector.
\item C0 - Prior covariance of the state vector.
}
}
\description{
The function creates a Fourier form periodic component for given period and harmonics.
}
\examples{
# create a seasonal component with first, second and fourth harmonics of a period of 365
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))

}
