% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwls_methods.R
\name{iwls_methods}
\alias{iwls_methods}
\alias{coef.iwls}
\alias{nobs.iwls}
\alias{print.iwls}
\title{Methods for objects of class \code{"iwls"}}
\usage{
\method{coef}{iwls}(object, ...)

\method{nobs}{iwls}(object, ...)

\method{print}{iwls}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{and object of class \code{c("iwls", "exdex")} returned from
\code{\link{iwls}}.}

\item{...}{Further arguments.  None are used.}

\item{x}{an object of class \code{c("iwls", "exdex")}, a result of
a call to \code{\link{iwls}}.}

\item{digits}{The argument \code{digits} to \code{\link{print.default}}.}
}
\value{
\code{coef.iwls}. A numeric scalar: the estimate of the extremal index
  \eqn{\theta}.

  \code{nobs.iwls}. A numeric scalar: the number of inter-exceedance times
  used in the fit.

  \code{print.iwls}. The argument \code{x}, invisibly.
}
\description{
Methods for objects of class \code{c("iwls", "exdex")} returned from
\code{\link{iwls}}.
}
\details{
\code{print.iwls} prints the original call to \code{\link{iwls}}
  and the estimate of the extremal index \eqn{\theta}.
}
\section{Examples}{

See the examples in \code{\link{iwls}}.
}

\seealso{
\code{\link{iwls}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.
}
