% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgaps_imt.R
\name{dgaps_imt}
\alias{dgaps_imt}
\title{Information matrix test under the \eqn{D}-gaps model}
\usage{
dgaps_imt(data, u, D = 1, inc_cens = TRUE)
}
\arguments{
\item{data}{A numeric vector or numeric matrix of raw data.  If \code{data}
  is a matrix then the log-likelihood is constructed as the sum of
  (independent) contributions from different columns. A common situation is
  where each column relates to a different year.

  If \code{data} contains missing values then \code{\link{split_by_NAs}} is
  used to divide the data into sequences of non-missing values.}

\item{u, D}{Numeric vectors.  \code{u} is a vector of extreme value
  thresholds applied to data.  \code{D} is a vector of values of the
  left-censoring parameter \eqn{D}, as defined in Holesovsky and Fusek
  (2020). See \code{\link{dgaps}}.

  Any values in \code{u} that are greater than all the observations in
  \code{data} will be removed without a warning being given.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from right-censored inter-exceedance times, relating to the
first and last observations. See \code{\link{dgaps}}.}
}
\value{
An object (a list) of class \code{c("dgaps_imt", "exdex")}
  containing
  \item{imt }{A \code{length(u)} by \code{length(D)} numeric matrix.
    Column i contains, for \eqn{D} = \code{D[i]}, the values of the
    information matrix test statistic for the set of thresholds in
    \code{u}.  The column names are the values in \code{D}.
    The row names are the approximate empirical percentage quantile levels
    of the thresholds in \code{u}.}
  \item{p }{A \code{length(u)} by \code{length(D)} numeric matrix
    containing the corresponding \eqn{p}-values for the test.}
  \item{theta }{A \code{length(u)} by \code{length(D)} numeric matrix
    containing the corresponding estimates of \eqn{\theta}.}
  \item{u,D }{The input \code{u} and \code{D}.}
}
\description{
Performs an information matrix test (IMT) to diagnose misspecification of
the \eqn{D}-gaps model of Holesovsky and Fusek (2020).
}
\details{
The general approach follows Suveges and Davison (2010).
  The \eqn{D}-gaps IMT is performed a over grid of all
  combinations of threshold and \eqn{D} in the vectors \code{u}
  and \code{D}.  If the estimate of \eqn{\theta} is 0 then the
  IMT statistic, and its associated \eqn{p}-value is \code{NA}.
}
\examples{
### Newlyn sea surges

u <- quantile(newlyn, probs = seq(0.1, 0.9, by = 0.1))
imt <- dgaps_imt(newlyn, u = u, D = 1:5)

### S&P 500 index

u <- quantile(sp500, probs = seq(0.1, 0.9, by = 0.1))
imt <- dgaps_imt(sp500, u = u, D = 1:5)

### Cheeseboro wind gusts (a matrix containing some NAs)

probs <- c(seq(0.5, 0.98, by = 0.025), 0.99)
u <- quantile(cheeseboro, probs = probs, na.rm = TRUE)
imt <- dgaps_imt(cheeseboro, u = u, D = 1:5)

### Uccle July temperatures

probs <- c(seq(0.7, 0.98, by = 0.025), 0.99)
u <- quantile(uccle720m, probs = probs, na.rm = TRUE)
imt <- dgaps_imt(uccle720m, u = u, D = 1:5)
}
\references{
Holesovsky, J. and Fusek, M. Estimation of the extremal index
  using censored distributions. Extremes 23, 197-213 (2020).
  \doi{10.1007/s10687-020-00374-3}

Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \doi{10.1214/09-AOAS292}
}
\seealso{
\code{\link{dgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{D}-gaps model.
}
