% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statement.R
\name{Statement}
\alias{Statement}
\title{Create \code{Statement} Object}
\usage{
Statement(general, specifics = NULL, env = NULL, decorate = NULL, ...)
}
\arguments{
\item{general}{A single character which gives a general statement
of a message.}

\item{specifics}{Optional. A character vector which gives a list of details
of a message. If \code{specifics} is a named vector, the names are used to
create bullets. if the name is \code{"x"} or \code{"i"}, the bullet will be colored
and bold. Any item with no name will be named \code{"x"}. Argument
\code{decorate} is used to turn on/off this process of adding and decorating
bullets. See "Examples" section.}

\item{env}{Optional. An environment or named list which is used
to evaluate the R code in the above arguments.
See "Examples" section and \code{\link[glue:glue]{glue::glue()}}.}

\item{decorate}{Optional. \code{TRUE} or \code{FALSE} which indicates if to decorate
the bullets of \code{specifics}. The default value is \code{TRUE}.}

\item{...}{Optional. Additional arguments which can be passed to
\code{\link[rlang:abort]{rlang::abort()}} or related functions.}
}
\value{
A list of class \code{Statement}.
}
\description{
Create a \code{Statement} object.

\code{Statement} objects are used to create structured normal, warning or
error messages.
}
\examples{
# quick example
general <- "I am the general statement of the message."
specifics <- c("Detail 1.", i = "Detail 2.", `*` = "Detail 3")
Statement(general, specifics)

# do not decorate bullets
Statement(general, specifics, decorate = FALSE)

# use R code in message
Statement("`x` is `{x}`.", env = list(x = 1))
}
\seealso{
\code{\link[=trigger]{trigger()}} for generating normal, warning and error messages.

\code{vignette("erify")} for a gentle introduction to this package.
}
