% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.curved.R
\name{is.curved}
\alias{is.curved}
\alias{is.curved.NULL}
\alias{is.curved.formula}
\alias{is.curved.ergm}
\title{Testing for curved exponential family}
\usage{
is.curved(object, ...)

\method{is.curved}{`NULL`}(object, ...)

\method{is.curved}{formula}(object, response = NULL, basis = NULL, ...)

\method{is.curved}{ergm}(object, ...)
}
\arguments{
\item{object}{An \code{\link{ergm}} object or an ERGM formula.}

\item{\dots}{Arguments passed on to lower-level functions.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}

\item{basis}{See \code{\link[=ergm]{ergm()}}.}
}
\value{
\code{TRUE} if the object represents a
curved exponential family; \code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM fit, formula, or some other
object represents a curved exponential family.

The method for \code{NULL} always returns \code{FALSE} by
convention.
}
\details{
Curvature is checked by testing if all model parameters are canonical.
}
\keyword{model}
