% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utils.R
\name{enformulate.curved-deprecated}
\alias{enformulate.curved-deprecated}
\alias{enformulate.curved}
\alias{enformulate.curved.ergm}
\alias{enformulate.curved.formula}
\title{Convert a curved ERGM into a form suitable as initial values for the same
ergm. Deprecated in 4.0.0.}
\usage{
enformulate.curved(object, ...)

\method{enformulate.curved}{ergm}(object, ...)

\method{enformulate.curved}{formula}(object, theta, ...)
}
\arguments{
\item{object}{An \code{\link{ergm}} object or an ERGM formula. The curved
terms of the given formula (or the formula used in the fit) must have all of
their arguments passed by name.}

\item{\dots}{Unused at this time.}

\item{theta}{Curved model parameter configuration.}
}
\value{
A list with the following components: \item{formula}{The formula
with curved parameter estimates incorporated.} \item{theta}{The coefficient
vector with curved parameter estimates removed.}
}
\description{
The generic \code{enformulate.curved} converts an \code{\link{ergm}} object
or formula of a model with curved terms to the variant in which the curved
parameters embedded into the formula and are removed from the parameter
vector. This is the form that used to be required by \code{\link[=ergm]{ergm()}} calls.
}
\details{
Because of a current kludge in \code{\link[=ergm]{ergm()}}, output from one run
cannot be directly passed as initial values (\code{control.ergm(init=)}) for
the next run if any of the terms are curved. One workaround is to embed the
curved parameters into the formula (while keeping \code{fixed=FALSE}) and
remove them from \code{control.ergm(init=)}.

This function automates this process for curved ERGM terms included with the
\CRANpkg{ergm} package. It does not work with curved
terms not included in ergm.
}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[=simulate.ergm]{simulate.ergm()}}
}
\keyword{model}
