% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterToGrid.R
\name{rasterToGrid}
\alias{rasterToGrid}
\title{Convert raster to sf grid}
\usage{
rasterToGrid(x, target, fun = "mean", crop = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{rasterLayer or rasterStack or SpatRaster}

\item{target}{epmGrid or sf object}

\item{fun}{function for summarizing raster cells to polygons}

\item{crop}{if TRUE, the raster will be cropped to the bounding box of the target}

\item{na.rm}{determines how \code{NA} cells are summarized}
}
\value{
sf polygons object, or a list of such objects if input has multiple layers.
}
\description{
Convert a raster to sf polygons object, matching the attributes
 of the target object.
}
\details{
By default, raster cells that overlap with target grid cell polygons
	will be averaged. If target is a raster grid, then \code{terra::resample}
	is used.
}
\examples{
library(terra)

# We have a terra grid object (for example, climate data read in as a raster)
# Here, we are just generating some random data for demo
env <- rast(vect(tamiasEPM[[1]]), resolution = 100000)
env[] <- sample(1:100, ncell(env), replace = TRUE)
plot(env)

# Now, if we are interested in doing analyses of environmental data in relation to 
# the epmGrid data we have, we want to convert the env data to the same grid structure
# where the cells align and where raster grid values are resampled and averaged.

newgrid <- rasterToGrid(env, target = tamiasEPM, fun = 'mean')
plot(newgrid)


# again but this time the input has multiple layers
env <- rast(vect(tamiasEPM[[1]]), resolution = 100000, nlyr = 3)
values(env[[1]]) <- sample(1:100, ncell(env), replace = TRUE)
values(env[[2]]) <- sample(1:200, ncell(env), replace = TRUE)
values(env[[3]]) <- sample(1:300, ncell(env), replace = TRUE)

newgrid <- rasterToGrid(env, target = tamiasEPM, fun = 'mean')






}
\author{
Pascal Title
}
