% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpRange.R
\name{plotSpRange}
\alias{plotSpRange}
\title{plot a single species' range}
\usage{
plotSpRange(
  x,
  taxon,
  taxonColor = "orange",
  basemap = "worldmap",
  lwd = 0.5,
  alpha = 1,
  use_tmap = FALSE,
  add = FALSE
)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{taxon}{taxon to plot}

\item{taxonColor}{color for plotting taxon's range}

\item{basemap}{if \code{'none'}, then only the grid is plotted. 
If \code{'worldmap'}, then vector map is plotted.
If \code{'interactive'}, then the plotting is done via your web browser.}

\item{lwd}{grid cell border width}

\item{alpha}{opacity of all colors and borders, ranging from 0 
(fully transparent) to 1 (fully opaque)}

\item{use_tmap}{if false, use sf or terra packages for plotting}

\item{add}{logical. If TRUE, adds the gridded taxon range to existing plot.}
}
\value{
nothing is returned
}
\description{
Plot one species' geographic range, as encoded in the epmGrid object.
}
\examples{
tamiasEPM

plotSpRange(tamiasEPM, 'Tamias_speciosus', use_tmap = FALSE)

}
\author{
Pascal Title
}
