% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cv.R
\name{plot_cv}
\alias{plot_cv}
\title{Visualizations for the prediction diagnostics of an estimated ecological niche}
\usage{
plot_cv(input, alpha = 0.05)
}
\arguments{
\item{input}{An object of class 'list' from the \code{\link{lrren}} function.}

\item{alpha}{Numeric. The two-tailed alpha level for the significance threshold (default is 0.05).}
}
\value{
This function produces two plots: 1) area under the receiver operating characteristic curve and 2) precision-recall curve. Each plot shows predictions for the log relative risk surface. The red-colored lines are the average curves.
}
\description{
Create multiple plots of output from the \code{\link{lrren}} function, specifically for the internal k-fold cross-validation diagnostics.
}
\examples{
if (interactive()) {
  set.seed(1234) # for reproducibility

# Using the 'bei' and 'bei.extra' data within {spatstat.data}

# Covariate data (centered and scaled)
  elev <- spatstat.data::bei.extra[[1]]
  grad <- spatstat.data::bei.extra[[2]]
  elev$v <- scale(elev)
  grad$v <- scale(grad)
  elev_raster <- raster::raster(elev)
  grad_raster <- raster::raster(grad)

# Presence data
  presence <- spatstat.data::bei
  spatstat.geom::marks(presence) <- data.frame("presence" = rep(1, presence$n),
                                               "lon" = presence$x,
                                               "lat" = presence$y)
  spatstat.geom::marks(presence)$elev <- elev[presence]
  spatstat.geom::marks(presence)$grad <- grad[presence]

# (Pseudo-)Absence data
  absence <- spatstat.random::rpoispp(0.008, win = elev)
  spatstat.geom::marks(absence) <- data.frame("presence" = rep(0, absence$n),
                                              "lon" = absence$x,
                                              "lat" = absence$y)
  spatstat.geom::marks(absence)$elev <- elev[absence]
  spatstat.geom::marks(absence)$grad <- grad[absence]

# Combine into readable format
  obs_locs <- spatstat.geom::superimpose(presence, absence, check = FALSE)
  obs_locs <- spatstat.geom::marks(obs_locs)
  obs_locs$id <- seq(1, nrow(obs_locs), 1)
  obs_locs <- obs_locs[ , c(6, 2, 3, 1, 4, 5)]
  
# Prediction Data
  predict_locs <- data.frame(raster::rasterToPoints(elev_raster))
  predict_locs$layer2 <- raster::extract(grad_raster, predict_locs[, 1:2])

# Run lrren
  test_lrren <- lrren(obs_locs = obs_locs,
                      predict_locs = predict_locs,
                      predict = TRUE,
                      cv = TRUE)
                      
# Run plot_cv                 
  plot_cv(input = test_lrren)
}

}
