% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-databricks.R
\name{chat_databricks}
\alias{chat_databricks}
\title{Chat with a model hosted on Databricks}
\usage{
chat_databricks(
  workspace = databricks_workspace(),
  system_prompt = NULL,
  model = NULL,
  token = NULL,
  api_args = list(),
  echo = c("none", "output", "all")
)
}
\arguments{
\item{workspace}{The URL of a Databricks workspace, e.g.
\code{"https://example.cloud.databricks.com"}. Will use the value of the
environment variable \code{DATABRICKS_HOST}, if set.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{model}{The model to use for the chat (defaults to "databricks-dbrx-instruct").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.

Available foundational models include:
\itemize{
\item \code{databricks-dbrx-instruct} (the default)
\item \verb{databricks-mixtral-8x7b-instruct}
\item \verb{databricks-meta-llama-3-1-70b-instruct}
\item \verb{databricks-meta-llama-3-1-405b-instruct}
}}

\item{token}{An authentication token for the Databricks workspace, or
\code{NULL} to use ambient credentials.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
Databricks provides out-of-the-box access to a number of \href{https://docs.databricks.com/en/machine-learning/model-serving/score-foundation-models.html}{foundation models}
and can also serve as a gateway for external models hosted by a third party.
\subsection{Authentication}{

\code{chat_databricks()} picks up on ambient Databricks credentials for a subset
of the \href{https://docs.databricks.com/en/dev-tools/auth/unified-auth.html}{Databricks client unified authentication}
model. Specifically, it supports:
\itemize{
\item Personal access tokens
\item Service principals via OAuth (OAuth M2M)
\item User account via OAuth (OAuth U2M)
\item Authentication via the Databricks CLI
\item Posit Workbench-managed credentials
\item Viewer-based credentials on Posit Connect. Requires the \pkg{connectcreds}
package.
}
}

\subsection{Known limitations}{

Databricks models do not support images, but they do support structured
outputs. Tool calling support is also very limited at present and is
currently not supported by ellmer.
}
}
\examples{
\dontrun{
chat <- chat_databricks()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
