% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\name{eia_cats}
\alias{eia_cats}
\alias{eia_child_cats}
\alias{eia_parent_cats}
\title{EIA categories}
\usage{
eia_cats(id = NULL, tidy = TRUE, cache = TRUE, key = eia_get_key())

eia_child_cats(id, cache = TRUE, key = eia_get_key())

eia_parent_cats(id, cache = TRUE, key = eia_get_key())
}
\arguments{
\item{id}{integer, category ID. If \code{NULL}, the API root category.}

\item{tidy}{logical, return a tidier result. See details.}

\item{cache}{logical, cache result for duration of R session using memoization. See details.}

\item{key}{API key: character if set explicitly; not needed if key is set globally. See \code{\link{eia_set_key}}.}
}
\value{
for \code{eia_cats}, a list of tibble data frames (or a less processed list, or character, depending on \code{tidy} value); others functions return a tibble data frame.
}
\description{
Obtain EIA categories.
}
\details{
By default, additional processing is done to return a list containing tibble data frames.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.

Set to \code{cache = FALSE} to force a new API call for updated data.
Using \code{FALSE} always makes a new API call and returns the result from the server.
\code{TRUE} uses memoization on a per R session basis, caching the result of the function call in memory for the duration of the R session.
You can reset the entire cache by calling \code{eia_clear_cache}.

\code{eia_child_cats} returns only the immediate child categories. \code{eia_parent_cats} returns all parents.
These are wrappers around \code{eia_cats} and always return a tibble data frame.
}
\examples{
\dontrun{
# use eia_set_key() to store stored API key
eia_cats()

eia_child_cats(389) # immedate children
eia_parent_cats(742) # all parents
}
}
