% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{chao1}
\alias{chao1}
\title{Chao1}
\usage{
chao1(counts, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A numeric vector.
}
\description{
Chao1 alpha diversity metric.\cr\cr
A non-parametric estimator of the number of unobserved species in a sample.
The Chao1 index estimates total species richness based on the number of
species that occur only once (singletons) and twice (doubletons) in the
sample.
}
\section{Calculation}{


Prerequisite: all counts are whole numbers.

In the formulas below, \code{x} is a single column (sample) from \code{counts}.
\eqn{n} is the total number of non-zero OTUs, \eqn{a} is the number of
singletons, and \eqn{b} is the number of doubletons.

\deqn{D = \displaystyle n + \frac{a^{2}}{2b}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(1, 0, 3, 2, 6)
  sum(x>0) + (sum(x==1) ^ 2) / (2 * sum(x==2))  
  #>  4.5
}\if{html}{\out{</div>}}

Note that when \eqn{x} does not have any singletons or doubletons
(\eqn{a = 0, b = 0}), the result will be \code{NaN}. When \eqn{x} has singletons
but no doubletons (\eqn{a > 0, b = 0}), the result will be \code{Inf}.
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Chao1 diversity values
    chao1(ex_counts)
    
    # Low diversity
    chao1(c(100, 1, 1, 1, 1)) # Inf
    
    # High diversity
    chao1(c(20, 20, 20, 20, 20)) # NaN
    
    # Low richness
    chao1(1:3) # 3.5
    
    # High richness
    chao1(1:100) # 100.5
    
}
\references{
Chao A 1984.
Non-parametric estimation of the number of classes in a population.
Scandinavian Journal of Statistics, 11:265-270.
}
\seealso{
Other alpha_diversity: 
\code{\link{faith}()},
\code{\link{inv_simpson}()},
\code{\link{shannon}()},
\code{\link{simpson}()}
}
\concept{alpha_diversity}
