% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_pis}
\alias{load_pis}
\title{Load eBird Status and Trends predictor importance data}
\usage{
load_pis(path, ext, model = c("occurrence", "count"), return_sf = FALSE)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to. The spatial component of the extent object must be provided in
unprojected, latitude-longitude coordinates.}

\item{model}{character; whether to make estimates for the occurrence or count
model.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
Data frame, or \link{sf} object if \code{return_sf = TRUE}, containing PI
estimates for each stixel for either the occurrence or count models. The
data are provided in a 'wide' format, with each row corresponding to the PI
estimates for a give stixel for the occurrence count model, and the
relative importance of each predictor in columns. Stixels are identified by
a unique \code{stixel_id}, and the centroid of the stixel in space and time is
specified by the \code{latitude}, \code{longitude}, and \code{day_of_year} columns. The
column \code{predictor} provides a code specifying the predictor variable. These
codes can be looked up in \code{ebirdst_predictors} for a brief description.
}
\description{
Loads the predictor importance (PI) data from the stixel_summary.db sqlite
database. PI estimates are provided for each stixel over which a model was
run and are identified by a unique stixel ID in addition to the coordinates
of the stixel centroid.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load predictor importance for the occurrence model
pis <- load_pis(path)

# plot the top 15 predictor importances
# define a spatiotemporal extent to plot data from
bb_vec <- c(xmin = -86.6, xmax = -82.2, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))
plot_pis(pis, ext = e, n_top_pred = 15, by_cover_class = TRUE)
}
}
