% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-habitat.R
\name{ebirdst_habitat}
\alias{ebirdst_habitat}
\alias{plot.ebirdst_habitat}
\title{eBird Status and Trends predictive habitat associations}
\usage{
ebirdst_habitat(path, ext, data = NULL, stationary_associations = FALSE)

\method{plot}{ebirdst_habitat}(x, n_habitat_types = 15, ...)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent over which to
calculate the habitat associations. Note that \strong{temporal component of \code{ext}
is ignored is this function}, habitat associations are always calculated
for the full year.}

\item{data}{as an alternative to providing the \code{path} argument specifying the
location of the data package, the data required to calculate habitat
associations can be provided explicitly as a named list of three data
frames: \code{pis} containing PI data from \code{\link[=load_pis]{load_pis()}}, \code{pds} containing PD
data from \code{\link[=load_pds]{load_pds()}}, and \code{stixels} containing stixel weights in a
\code{weight} column. All data should be provided at the stixel level,
identified by the \code{stixel_id} column, and only those stixels appearing in
the \code{stixels} data frame will be used. Typically stixel weights are the
proportion of the focal region that the given stixel overlaps. Ignored if
\code{path} is provided. \strong{In most cases, users will want to avoid using these
arguments and simply provide \code{path} instead.}}

\item{stationary_associations}{logical; when the habitat association should
be assumed to vary throughout the year and estimates should be made for
each week of the year (the default) or habitat associations should be
assumed constant throughout the year and a single set of estimates made for
the full year. Annual estimates should only be made when you expect the
associations to be constant throughout the year, e.g. for resident species.}

\item{x}{\link{ebirdst_habitat} object; habitat relationships as calculated by
\code{\link[=ebirdst_habitat]{ebirdst_habitat()}}.}

\item{n_habitat_types}{number of habitat types to include in the cake plot.
The most important set of predictors will be chosen based on the maximum
weekly importance value across the whole year.}

\item{...}{ignored.}
}
\value{
An \code{ebirdst_habitat} object, consisting of a data frame giving the
predictor importance and directionality for each predictor for each week of
the year. The columns are:
\itemize{
\item \code{predictor}: the name of the predictor
\item \code{week}: the date of the center of the week, expressed as "MM-DD". This
column will be missing if \code{stationary_associations = TRUE}.
\item \code{importance}: the relative importance of the predictor, these values are
scaled so they sum to 1 within each week.
\item \code{prob_pos_slope}: the predicted probability that the slope of the PD
\item \code{direction}: the direction of the relationship, either 1 for a positive
relationship, -1 for a negative relationship, or NA when the direction of
the relationship is not significant.
}
}
\description{
Combine the predictor importance (PI) and partial dependence (PD) data to
provide an estimate of the importance and directionality of the land cover
classes (i.e. habitat) used as covariates in the occurrence probability
model. \strong{Note:} This is one of, if not the most, computationally expensive
operations in the package.
}
\details{
The Status and Trends models use both effort (e.g. number of
observers, length of checklist) and habitat (e.g. elevation, percent forest
cover) covariates; for the full list consult \link{ebirdst_predictors}. This
function calculates habitat associations only for the following covariates
that most closely represent metrics of available habitat. In all cases
these are calculated within a 1.5 km radius of each checklist:
\itemize{
\item Land cover: percent of each landcover class
\item Water cover: percent of each watercover class
\item Intertidal: percent cover of intertidal mudflats
\item Nighttime lights: total reflectance of nighttime lights
\item Roads: road density. There are 5 covariates distinguishing between
different road types; however, these are grouped together for the sake of
the habitat associations.
}

The \code{plot()} method can be used to produce a cake plot, a stacked area chart
showing habitat associations in which area indicates the importance of a
given land cover class and the position above or below the x-axis indicates
the direction of the relationship.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# define a spatial extent to calculate ppms over
e <- ebirdst_extent(c(xmin = -90, xmax = -82, ymin = 41, ymax = 48))

# compute habitat associations
habitat <- ebirdst_habitat(path = path, ext = e)
print(habitat)
# produce a cake plot
plot(habitat)
}
}
