% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stixelize.R
\name{stixelize}
\alias{stixelize}
\title{Generate polygons for eBird Status and Trends stixels}
\usage{
stixelize(x)
}
\arguments{
\item{x}{\code{data.frame} or \link{sf} object; stixel summary data loaded with
\code{\link[=load_stixels]{load_stixels()}}, or any other data frame with fields \code{lon}, \code{lat},
\code{stixel_width}, and \code{stixel_hight}.}
}
\value{
\link{sf} object with geometry column storing polygons representing the
stixels boundaries.
}
\description{
eBird Status and Trends divides space and time into variably sized "stixels"
within which individual base models are fit. The process of stixelization is
performed many times and the prediction at any given point is the median of
the predictions from all the stixels that that point falls in.
\code{\link[=load_stixels]{load_stixels()}} loads information on all the stixels that compromise a
species' Status and Trends model, with stixels identified by the location of
their centroid. This function uses this information to define polygons for
each stixel and attaches them to the original data in the form of an \link{sf}
object.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load stixel summary information
stixels <- load_stixels(path)

# build stixel polygons
stixelize(stixels)
}
}
