% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeMissings.R
\name{changeMissings}
\alias{changeMissings}
\title{Change missing code.}
\usage{
changeMissings(GADSdat, varName, value, missings)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Character string of a variable name.}

\item{value}{Numeric values.}

\item{missings}{Character string of the new missing codes, either \code{"miss"} or \code{"valid"}.}
}
\value{
Returns the \code{GADSdat} object with changed meta data.
}
\description{
Change or add missing codes of a variable as part of a \code{GADSdat} or \code{all_GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper of \code{\link{getChangeMeta}} and
\code{\link{applyChangeMeta}}.
}
\examples{
# Set a specific value to missing
pisa2 <- changeMissings(pisa, varName = "computer_age",
                        value = 5, missings = "miss")

# Set multiple values to missing
pisa3 <- changeMissings(pisa, varName = "computer_age",
                        value = 1:4,
                        missings = c("miss", "miss", "miss", "miss"))

# Set a specific value to not missing
pisa4 <- changeMissings(pisa2, varName = "computer_age",
                        value = 5, missings = "valid")

}
