% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dataset.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Generate a dataset}
\usage{
generate_dataset(
  model,
  output_dir = NULL,
  make_plots = FALSE,
  store_dimred = model$simulation_params$compute_dimred,
  store_cellwise_grn = model$simulation_params$compute_cellwise_grn,
  store_rna_velocity = model$simulation_params$compute_rna_velocity
)
}
\arguments{
\item{model}{A dyngen initial model created with \code{\link[=initialise_model]{initialise_model()}}.}

\item{output_dir}{If not \code{NULL}, then the generated model and dynwrap
dataset will be written to files in this directory.}

\item{make_plots}{Whether or not to generate an overview of the dataset.}

\item{store_dimred}{Whether or not to store the dimensionality reduction constructed on the true counts.}

\item{store_cellwise_grn}{Whether or not to also store cellwise GRN information.}

\item{store_rna_velocity}{WHether or not to store the log propensity ratios.}
}
\value{
A list containing a dyngen model (\code{li$model}) and a dynwrap dataset (\code{li$dataset}).
}
\description{
This function contains the complete pipeline for generating a dataset
with \pkg{dyngen}. In order to have more control over how the dataset
is generated, run each of the steps in this function separately.
}
\examples{
\donttest{
out <- 
  initialise_model(
    backbone = backbone_bifurcating()
  ) \%>\%
  generate_dataset()
  
model <- out$model
dataset <- out$dataset
}
}
