% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_right_join}
\alias{p_right_join}
\title{Right join}
\usage{
p_right_join(
  x,
  y,
  ...,
  .messages = c("{.count.lhs} on LHS", "{.count.rhs} on RHS",
    "{.count.out} in linked set"),
  .headline = "Right join by {.keys}"
)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{Other parameters passed onto methods.
  Named arguments passed on to \code{\link[dplyr:mutate-joins]{dplyr::right_join}}\describe{
    \item{\code{by}}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}
\item{\code{copy}}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}
\item{\code{suffix}}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}
\item{\code{keep}}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?
\itemize{
\item If \code{NULL}, the default, joins on equality retain only the keys from \code{x},
while joins on inequality retain the keys from both inputs.
\item If \code{TRUE}, all keys from both inputs are retained.
\item If \code{FALSE}, only keys from \code{x} are retained. For right and full joins,
the data in key columns corresponding to rows that only exist in \code{y} are
merged into the key columns from \code{x}. Can't be used when joining on
inequality conditions.
}}
\item{\code{na_matches}}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}
\item{\code{multiple}}{Handling of rows in \code{x} with multiple matches in \code{y}.
For each row of \code{x}:
\itemize{
\item \code{"all"}, the default, returns every match detected in \code{y}. This is the
same behavior as SQL.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"}
if you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
}}
\item{\code{unmatched}}{How should unmatched keys that would result in dropped rows
be handled?
\itemize{
\item \code{"drop"} drops unmatched keys from the result.
\item \code{"error"} throws an error if unmatched keys are detected.
}

\code{unmatched} is intended to protect you from accidentally dropping rows
during a join. It only checks for unmatched keys in the input that could
potentially drop rows.
\itemize{
\item For left joins, it checks \code{y}.
\item For right joins, it checks \code{x}.
\item For inner joins, it checks both \code{x} and \code{y}. In this case, \code{unmatched} is
also allowed to be a character vector of length 2 to specify the behavior
for \code{x} and \code{y} independently.
}}
\item{\code{relationship}}{Handling of the expected relationship between the keys of
\code{x} and \code{y}. If the expectations chosen from the list below are
invalidated, an error is thrown.
\itemize{
\item \code{NULL}, the default, doesn't expect there to be any relationship between
\code{x} and \code{y}. However, for equality joins it will check for a many-to-many
relationship (which is typically unexpected) and will warn if one occurs,
encouraging you to either take a closer look at your inputs or make this
relationship explicit by specifying \code{"many-to-many"}.

See the \emph{Many-to-many relationships} section for more details.
\item \code{"one-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"one-to-many"} expects:
\itemize{
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"many-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
}
\item \code{"many-to-many"} doesn't perform any relationship checks, but is provided
to allow you to be explicit about this relationship if you know it
exists.
}

\code{relationship} doesn't handle cases where there are zero matches. For that,
see \code{unmatched}.}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, \{.keys\} for the joining columns, \{.count.lhs\},
\{.count.rhs\}, \{.count.out\} for the input and output dataframes sizes
respectively}

\item{.headline}{a glue spec. The glue code can use any global variable,
\{.keys\} for the joining columns, \{.count.lhs\}, \{.count.rhs\},
\{.count.out\} for the input and output dataframes sizes respectively}
}
\value{
the join of the two dataframes with the history graph updated.
}
\description{
Mutating joins behave as \code{dplyr} joins, except the history graph of the two
sides of the joins is merged resulting in a tracked dataframe with the
history of both input dataframes. See \code{\link[dplyr:mutate-joins]{dplyr::right_join()}} for more details
on the underlying functions.
}
\examples{
library(dplyr)
library(dtrackr)
# Joins across data sets

# example data uses the dplyr starways data
people = starwars \%>\% select(-films, -vehicles, -starships)
films = starwars \%>\% select(name,films) \%>\% tidyr::unnest(cols = c(films))

lhs = people \%>\% track() \%>\% comment("People df {.total}")
rhs = films \%>\% track() \%>\% comment("Films df {.total}") \%>\%
  comment("a test comment")

# Full join
join = lhs \%>\% full_join(rhs, by="name", multiple = "all") \%>\% comment("joined {.total}")
# See what the history of the graph is:
join \%>\% history()
nrow(join)
# Display the tracked graph (not run in examples)
# join \%>\% flowchart()

}
\seealso{
dplyr::right_join()
}
