% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{graphs_find_subgraphs}
\alias{graphs_find_subgraphs}
\title{Subgraphs in Undirected Graphs/Networks}
\usage{
graphs_find_subgraphs(id_1, id_2, verbose = 1L)
}
\arguments{
\item{id_1}{vector of integers indicating ids}

\item{id_2}{vector of integers indicating ids}

\item{verbose}{in integer indicating the amount of verbosity; good for long running tasks or to 
get more information about the workings of the algorithm; currently accepted values: 0, 1, 2}
}
\value{
An integer vector with subgraph ids such that each distinct subgraph - i.e. all 
  nodes are reachable within the graph and no node outside the subgraph is reachable - 
  gets a distinct integer value. Integer values are assigned via
}
\description{
Finding and indexing subgraphs in undirected graph.
}
\details{
Input is given as two vectors where each pair of node ids `id_1[i]` - `id_2[i]` indicates an 
edge between two nodes.
}
\examples{

graphs_find_subgraphs(c(1,2,1,5,6,6), c(2,3,3,4,5,4), verbose = 0)
graphs_find_subgraphs(c(1,2,1,5,6,6), c(2,3,3,4,5,4), verbose = 2)

}
