"confint.drc" <- function(object, parm, level = 0.95, ...)
{
    ## Matching parameter names
    if (!missing(parm))
    {
        matchVec <- object$"parNames"[[2]]%in%parm
        if (!any(matchVec)) {stop("The 'parm' argument does not match an actual parameter")}
    } else {
        matchVec <- rep(TRUE, length(object$"parNames"[[2]]) )
    }


    ## Retrieving estimates and estimated standard errors
    estMat <- summary(object)$"estimates"[matchVec, 1:2, drop = FALSE]


    ## Constructing matrix of confidence intervals
    confMat <- matrix(0, dim(estMat)[1], 2)

    alphah <- (1 - level)/2 
    two <- qnorm(1 - alphah)
    confMat[, 1] <- estMat[, 1] -  two * estMat[, 2]
    confMat[, 2] <- estMat[, 1] +  two * estMat[, 2]


    ## Formatting matrix
    colnames(confMat) <- c(paste(format(100*alphah), "%", sep=" "), paste(format(100*(1-alphah)), "%", sep=" ") )
    rownames(confMat) <- rownames(estMat)

    return(confMat)
}
