% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{cv_spline_score}
\alias{cv_spline_score}
\title{K-fold cross-validation for spline_score.}
\usage{
cv_spline_score(x, df = 2:15, nfolds = 5L, tol = 0.001, nmax = NULL)
}
\arguments{
\item{x}{vector of datapoints}

\item{df}{vector of smoothing parameters for the
non-parametric score estimator, corresponding to the
effective degrees of freedom for a smoothing spline.}

\item{nfolds}{integer number of cross-validation folds.}

\item{tol}{numeric tolerance, minimum distance between neighbouring points,
to avoid singularities.}

\item{nmax}{if specified, overrides tol as maximal number of unique points.}
}
\value{
list of 5 elements: df vector, cv vector of corresponding
cross-validation scores, se vector of standard error estimates,
df_min cross-validation minimiser, df_1se largest smoothing
parameter within CV score within one standard error of df_min.
}
\description{
K-fold cross-validation for spline_score.
}
\examples{
set.seed(0)
x <- stats::rt(100, df=4)
cv_spline_score(x)

x <- stats::rlogis(500)
cvspl <- cv_spline_score(x)
cvspl$df_min
}
