% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootAverageDominanceAnalysis.r
\name{bootAverageDominanceAnalysis}
\alias{bootAverageDominanceAnalysis}
\title{Bootstrap average values for Dominance Analysis}
\usage{
bootAverageDominanceAnalysis(
  x,
  R,
  constants = c(),
  terms = NULL,
  fit.functions = "default",
  null.model = NULL,
  ...
)
}
\arguments{
\item{x}{lm, glm or lmer model}

\item{R}{number on bootstrap resamples}

\item{constants}{vector of predictors to remain unchanged between models.
i.e. vector of variables not subjected to bootstrap analysis.}

\item{terms}{vector of terms to be analyzed. By default, obtained from the model}

\item{fit.functions}{list of functions which provides fit indices for model.
See \code{fit.functions} param in \code{\link{dominanceAnalysis}}
function.}

\item{null.model}{only for linear mixed models, null model against to test the submodels.
i.e. only random effects, without any fixed effect.}

\item{...}{Other arguments provided to lm or lmer (not implemented yet).}
}
\description{
Bootstrap average values and correspond standard errors for each predictor
in the dominance analysis. Those values are used for general dominance.
}
\details{
Use \code{summary()} to get a nice formatted \code{data.frame} object.
}
\examples{
\donttest{
lm.1<-lm(Employed~.,longley)
da.ave.boot<-bootAverageDominanceAnalysis(lm.1,R=1000)
summary(da.ave.boot)
}
}
