% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encounter_creator.R
\name{encounter_creator}
\alias{encounter_creator}
\title{Balance a Combat Encounter for Given Party Composition and Difficulty}
\usage{
encounter_creator(party_level = NULL, party_size = NULL, difficulty = NULL)
}
\arguments{
\item{party_level}{(numeric) integer indicating the average party level. If all players are the same level, that level is the average party level}

\item{party_size}{(numeric) integer indicating how many player characters (PCs) are in the party}

\item{difficulty}{(character) one of "easy", "medium", "hard", or "deadly" for the desired difficulty of the encounter}
}
\value{
(dataframe) creature experience point (XP) values as well as the maximum XP for an encounter of the specified difficulty and the realized XP cost of the returned creatures
}
\description{
Identifies set of creature XP values that constitute a balanced encounter of specified difficulty for given party composition information (i.e., average player character level and number of party members). Creature selection is semi-random so re-running this function will return similar but not necessarily identical results. It is not always possible to exactly spend all available XP so the true maximum XP and the realized XP (see `?dndR::xp_pool` and `?dndR::xp_cost`) are both returned in the output for context. This function _will not_ exceed the allowed XP so you may need to alter the party information and/or difficulty arguments in order to return an encounter that meets your needs.
}
\examples{
# Create a hard encounter for a 2-person, 9th level party
encounter_creator(party_level = 9, party_size = 2, difficulty = "hard")

}
