% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dmdScheme_validation.R
\name{print.dmdScheme_validation}
\alias{print.dmdScheme_validation}
\title{Print method for \code{dmdScheme_validation} object}
\usage{
\method{print}{dmdScheme_validation}(
  x,
  level = 1,
  listLevel = 3,
  type = "default",
  format = "markdown",
  error = c(0, 1, 2, 3, NA),
  ...
)
}
\arguments{
\item{x}{object of class \code{dmdScheme_validation}}

\item{level}{level at which the header structure should start}

\item{listLevel}{level at which the elements should be represented as lists and not headers anymore}

\item{type}{type of output, can be either \code{"default"}, \code{"summary"} or \code{"details"}. Default is \code{"default"}}

\item{format}{format in which the details tables should be printed. All values as used in \code{knitr::kable()} are allowed.}

\item{error}{numeric v ector, containing error levels to print. Default is all error levels.}

\item{...}{additional arguments for the function \code{knitr::kable()} function to format the table.}
}
\value{
invisibly returns x
}
\description{
When using different values for \code{format}, different outputs are generated:
\itemize{
   \item{"default"}{print \code{x} as \code{list}}
   \item{"summary"}{print the description and errors of \code{x} as structured output, using the format as specified in the argument \code{format}}
   \item{"details"}{print the details of \code{x} as structured output, using the format as specified in the argument \code{format}}
}
}
\examples{
x <- validate(dmdScheme_raw())

## default printout as list
x

## the same as
print(x, type = "default")

## the summary
print(x, type = "summary")

## and the details
print(x, type = "details")

## can be used in a Rmd file like:
# ```{r, results = "asis"}
#    print(result, level = 2, listLevel = 20, type = "summary")
# ```
}
