% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc-package.R
\docType{package}
\name{dmbc-package}
\alias{dmbc-package}
\alias{dmbc-pkg}
\alias{dmbc-p}
\title{Model-Based Clustering of Several Dissimilarity Matrices.}
\description{
The \pkg{dmbc} package implements a Bayesian algorithm for clustering a set
of dissimilarity matrices within a model-based framework. In particular,
we consider the case where \emph{S} matrices are available, each
describing the dissimilarities among \emph{n} objects, possibly expressed by
\emph{S} subjects (judges), or measured under different experimental conditions,
or with reference to different characteristics of the objects them- selves.
Specifically, we focus on binary dissimilarities, taking values 0 or 1
depending on whether or not two objects are deemed as similar, with the goal
of analyzing such data using multidimensional scaling (MDS). Differently
from the standard MDS algorithms, we are interested in partitioning the
dissimilarity matrices into clusters and, simultaneously, to extract a
specific MDS configuration for each cluster. The parameter estimates
are derived using a hybrid Metropolis-Gibbs Markov Chain Monte Carlo
algorithm. We also include a BIC-like criterion for jointly selecting the
optimal number of clusters and latent space dimensions.

For efficiency reasons, the core computations in the package are implemented
using the \code{C} programming language and the \pkg{RcppArmadillo} package.

The \pkg{dmbc} package also supports the simulation of multiple chains
through the support of the \pkg{parallel} package.

Plotting functionalities are imported from the nice \pkg{bayesplot} package.
Currently, the package includes methods for binary data only. In future
releases routines will be added specifically for continuous (i.e. normal),
multinomial and count data.
}
\section{\pkg{dmbc} classes}{

The \pkg{dmbc} package defines the following new classes:
\itemize{
  \item{\code{\link{dmbc_data}}: }{defines the data to use in a DMBC model.}
  \item{\code{\link{dmbc_model}}: }{defines a DMBC model.}
  \item{\code{\link{dmbc_fit}}: }{defines the results of a DMBC analysis
    for a single MCMC chain.}
  \item{\code{\link{dmbc_fit_list}}: }{defines the results of a DMBC analysis
    for multiple MCMC chains.}
  \item{\code{\link{dmbc_ic}}: }{defines the results of the computation of
    the information criterion for a DMBC analysis.}
  \item{\code{\link{dmbc_config}}: }{defines the estimate of the latent
    configuration for a DMBC analysis.}
}
The package includes \code{print}, \code{summary} and \code{plot} methods
  for each one of these classes.
}

\section{Resources}{

\itemize{
 \item{\strong{Bug reports}:}{
 If you have noticed a bug that needs to be fixed, please let us know at the
 \pkg{dmbc} issue tracker on GitHub:

 \url{https://github.com/sergioventurini/dmbc/issues/}.
 }
 \item{\strong{General questions and help}:}{
 To ask a question about \pkg{dmbc} send and email to:

 \email{sergio.venturini@unito.it}.
}
}
}

\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link[bayesplot]{theme_default}} for the default ggplot theme
 used by \pkg{bayesplot}.

\code{\link[bayesplot]{bayesplot-colors}} to set or view the color
 scheme used for plotting with \pkg{bayesplot}.

\code{\link[ggplot2]{ggsave}} in \pkg{ggplot2} for saving plots.
}
