% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blau.R
\name{ds_blau}
\alias{ds_blau}
\alias{blau}
\title{Compute Blau's Index}
\usage{
ds_blau(.data, .cols, .name)

blau(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with.}

\item{.name}{name for column with Blau index. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_blau from blau}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Blau's Index
}
\examples{
data("de_county")
ds_blau(de_county, starts_with('pop_'))
ds_blau(de_county, starts_with('pop_'), 'blau')
}
\concept{div}
