% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tukey.R
\name{cdf.Tukey}
\alias{cdf.Tukey}
\title{Evaluate the cumulative distribution function of a Tukey distribution}
\usage{
\method{cdf}{Tukey}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{Tukey} distribution created by a call to \code{\link[=Tukey]{Tukey()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{ptukey}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the cumulative distribution function of a Tukey distribution
}
\examples{

set.seed(27)

X <- Tukey(4L, 16L, 2L)
X

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Tukey distribution: 
\code{\link{quantile.Tukey}()}
}
\concept{Tukey distribution}
