% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{quantile.Geometric}
\alias{quantile.Geometric}
\title{Determine quantiles of a Geometric distribution}
\usage{
\method{quantile}{Geometric}(x, probs, ...)
}
\arguments{
\item{x}{A \code{Geometric} object created by a call to \code{\link[=Geometric]{Geometric()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
Determine quantiles of a Geometric distribution
}
\examples{

set.seed(27)

X <- Geometric(0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Geometric distribution: 
\code{\link{cdf.Geometric}()},
\code{\link{pdf.Geometric}()},
\code{\link{random.Geometric}()}
}
\concept{Geometric distribution}
